% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{nsCorr}
\alias{nsCorr}
\title{Calculate a nonstationary Matern correlation matrix}
\usage{
nsCorr(dist1_sq, dist2_sq, dist12, Sigma11, Sigma22, Sigma12, nu, d)
}
\arguments{
\item{dist1_sq}{N x N matrix; contains values of pairwise squared distances
in the x-coordinate.}

\item{dist2_sq}{N x N matrix; contains values of pairwise squared distances
in the y-coordinate.}

\item{dist12}{N x N matrix; contains values of pairwise signed cross-
distances between the x- and y-coordinates. The sign of each element is
important; see \code{nsDist} function for the details of this calculation.
in the x-coordinate.}

\item{Sigma11}{Vector of length N; contains the 1-1 element of the
anisotropy process for each station.}

\item{Sigma22}{Vector of length N; contains the 2-2 element of the
anisotropy process for each station.}

\item{Sigma12}{Vector of length N; contains the 1-2 element of the
anisotropy process for each station.}

\item{nu}{Scalar; Matern smoothness parameter. \code{nu = 0.5} corresponds
to the Exponential correlation; \code{nu = Inf} corresponds to the Gaussian
correlation function.}

\item{d}{Scalar; dimension of the spatial coordinates.}
}
\value{
A correlation matrix for a fixed set of stations and fixed
parameter values.
}
\description{
\code{nsCorr} calculates a nonstationary correlation matrix for a
fixed set of locations, based on vectors of the unique anisotropy
parameters for each station. Since the correlation function uses a
spatially-varying Mahalanobis distance, this function requires coordinate-
specific distance matrices (see below). The function is coded as a
\code{nimbleFunction} (see the \code{nimble} package) but can also be
used as a regular R function.
}
\examples{
# Generate some coordinates and parameters
coords <- cbind(runif(100),runif(100))
Sigma11 <- rep(1, 100) # Identity anisotropy process
Sigma22 <- rep(1, 100)
Sigma12 <- rep(0, 100)
nu <- 2
# Calculate distances
dist_list <- nsDist(coords)
# Calculate the correlation matrix
corMat <- nsCorr(dist_list$dist1_sq, dist_list$dist2_sq, dist_list$dist12,
                 Sigma11, Sigma22, Sigma12, nu, ncol(coords))

}
