% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.corranalysis.R
\name{is.corranalysis}
\alias{is.corranalysis}
\title{Reports whether x is a 'corranalysis' object}
\usage{
is.corranalysis(x)
}
\arguments{
\item{x}{an object to test.}
}
\value{
Returns TRUE if its argument is of class \code{corranalysis} and FALSE otherwise.
}
\description{
Reports whether x is a 'corranalysis' object
}
\examples{
data <- data.frame(Pbox$PTS,Pbox$P3M,Pbox$P2M,
                   Pbox$OREB + Pbox$DREB,Pbox$AST,
                   Pbox$TOV,Pbox$STL,Pbox$BLK)/Pbox$MIN
names(data) <- c("PTS","P3M","P2M","REB","AST","TOV","STL","BLK")
data <- subset(data, Pbox$MIN >= 500)
out <- corranalysis(data)
is.corranalysis(out)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{corranalysis}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketball.analyzer.help@gmail.com})
}
