% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eib.plot.R
\name{eib.plot.bcea}
\alias{eib.plot.bcea}
\alias{eib.plot}
\title{Expected Incremental Benefit (EIB) Plot}
\usage{
\method{eib.plot}{bcea}(
  he,
  comparison = NULL,
  pos = "bottomright",
  size = NULL,
  plot.cri = NULL,
  graph = options("bcea.graph"),
  ...
)

eib.plot(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{Selects the comparator, in case of more than two
interventions being analysed. Default as NULL plots all the comparisons
together. Any subset of the possible comparisons can be selected (e.g.,
\code{comparison=c(1,3)} or \code{comparison=2}).}

\item{pos}{Parameter to set the position of the legend (only relevant for
multiple interventions, ie more than 2 interventions being compared).
Can be given in form
of a string \code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot.}

\item{size}{Value (in millimetres) of the size of the willingness to pay
label. Used only if \code{graph="ggplot2"}, otherwise it will be ignored
with a message. If set to \code{NA}, the break-even point line(s) and
label(s) are suppressed, with both base graphics and ggplot2.}

\item{plot.cri}{Logical value. Should the credible intervals be plotted
along with the expected incremental benefit? Default as \code{NULL} draws
the 95\\% credible intervals if only one comparison is selected, and does not
include them for multiple comparisons.  Setting \code{plot.cri=TRUE} or
\code{plot.cri=FALSE} forces the function to add the intervals or not. The
level of the intervals can be also set, see \ldots{} for more details.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the three options \code{"base"},
\code{"ggplot2"} or \code{"plotly"}. Default value is \code{"base"}. This is set globally
upon loading \code{BCEA} and can be modified for instance by using
\code{options("bcea.graph"="gg")}, or \verb{options("bcea.graph="plotly")}. Partial
matching still applies (so \code{gg} or \code{pl} also work). Not all plotting
functions have a \code{"plotly"} implementation, yet -- see help for the specifics.}

\item{...}{If \code{graph="ggplot2"} and a named theme object is supplied,
it will be added to the ggplot object. Additional arguments:
\itemize{
\item \code{alpha} can be used to set the CrI level when \code{plot.cri=TRUE},
with a default value of \code{alpha=0.05}.
\item \code{cri.quantile} controls the the method of calculation of the credible
intervals. The default value \code{cri.quantile=TRUE} defines the CrI as the
interval between the \code{alpha/2}-th and \code{1-alpha/2}-th quantiles of
the IB distribution. Setting \code{cri.quantile=FALSE} will use a normal
approximation on the IB distribution to calculate the intervals.
\item \code{line = list(color)}: specifies the line colour(s) - all graph types.
\item \code{line = list(type)}: specifies the line type(s) as lty numeric values - all graph types.
\item \code{area_include}: include area under the EIB curve - plotly only.
\item \code{area_color}: specifies the AUC curve - plotly only.}}
}
\value{
\item{eib}{ If \code{graph="ggplot2"} a ggplot object, or if \code{graph="plotly"}
a plotly object containing the requested plot. Nothing is returned when \code{graph="base"},
the default.} The function produces a plot of the
Expected Incremental Benefit as a function of the discrete grid
approximation of the willingness to pay parameter. The break even point
(i.e. the point in which the EIB = 0, i.e. when the optimal decision changes
from one intervention to another) is also showed by default. The value \verb{k*} is
the discrete grid approximation of the ICER.
}
\description{
Produces a plot of the Expected Incremental Benefit (EIB) as a function of
the willingness to pay.
}
\examples{
data(Vaccine)
 
# Runs the health economic evaluation using BCEA
m <- bcea(
      e=eff,
      c=cost,               # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e, c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0, Kmax)
      plot=FALSE            # plots the results
)
eib.plot(m)
eib.plot(m, graph = "ggplot2") + ggplot2::theme_linedraw()

data(Smoking)
treats <- c("No intervention", "Self-help",
            "Individual counselling", "Group counselling")
m <- bcea(eff, cost, ref = 4, interventions = treats, Kmax = 500)
eib.plot(m)

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=bcea]{bcea()}},
\code{\link[=ib.plot]{ib.plot()}},
\code{\link[=ceplane.plot]{ceplane.plot()}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
