% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sumry.lm.R
\name{print.sumry.lm}
\alias{print.sumry.lm}
\title{Print a \code{sumry} Summarization for Linear Model Objects}
\usage{
\method{print}{sumry.lm}(
  x,
  ...,
  digits = max(5, getOption("digits") - 2),
  symbolic.cor = NULL,
  signif.stars = getOption("show.signif.stars"),
  options = NULL,
  na.print = "",
  eps = .Machine$double.eps
)
}
\arguments{
\item{x}{An object of class \code{sumry.lm} or \code{lm}.}

\item{...}{Additional arguments (not currently used).}

\item{digits}{Minimal number of significant digits. Defaults to \code{max(5, getOption("digits") - 2)}.}

\item{symbolic.cor}{Not implemented. Defaults to \code{NULL}.}

\item{signif.stars}{Logical; whether to show significance stars in the coefficients table. Defaults to \code{getOption("show.signif.stars")}.}

\item{options}{A character vector of optional summary tables to print (e.g., \code{"v.correlation"}, \code{"cov.unscaled"}, \code{"correlation"}, \code{"fits"}). Printed in the given order if present.}

\item{na.print}{String to use for NA values in the tables.}

\item{eps}{Smallest positive floating-point value, used for formatting near-zero residuals. Defaults to \code{.Machine$double.eps}.}
}
\value{
Invisibly return the unmodified object included in the call.
}
\description{
Prints a comprehensive summary for objects of class \code{summary.lm} or \code{lm}, including model statistics, ANOVA table, coefficients, and optional tables (correlations, covariance, fits), followed by a five-number summary of residuals and the model call.
}
\details{
The function prints summary statistics, ANOVA, and coefficients tables for a linear model in order, along with specified optional tables if provided. It concludes with a five-number-plus-mean summary of residuals and the model call.
}
\examples{

mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
sumry(mdl)
sumry(mdl, options = c("correlation", "fits"))

}
\seealso{
\code{\link{sumry.lm}}, \code{\link{print.table.sumry.lm}}
}
