% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.var.R
\name{lm_plot.var}
\alias{lm_plot.var}
\title{Plot Residuals vs. Fitted Values to Assess Homoskedasticity}
\usage{
lm_plot.var(
  mdl,
  ...,
  pval.BP = FALSE,
  parms = lm_plot.parms(mdl),
  df = lm_plot.df(mdl, parms = parms)
)
}
\arguments{
\item{mdl}{A fitted model object (typically from \code{\link[stats]{lm}}).}

\item{...}{Additional arguments (not currently used).}

\item{pval.BP}{(logical, default = FALSE) option to include Breusch-Pagan p-value on the plot.}

\item{parms}{List of plotting parameters, usually from \code{lm_plot.parms()}.}

\item{df}{Data frame with augmented model data. Defaults to \code{lm_plot.df(mdl)}.}
}
\value{
A \code{ggplot} object representing the residuals versus fitted values plot. Included as an attribute \code{"parms"} is a list containing:
\itemize{
  \item \code{lim} Plotted limits on \code{x} and \code{y} axes,
  \item \code{pval.BP} Option to show Breusch-Pagan p-value,
  \item \code{BP} The \code{htest} object with Breusch-Pagan test results.
}
}
\description{
Produces a scatter plot of residuals against fitted values from a linear model, highlighting outlier points and optionally displaying the Breusch-Pagan test p-value for heteroskedasticity.
}
\details{
The plot visualizes residuals versus fitted values to assess homoskedasticity (constant variance). Points are colored and shaped by outlier status, and outlier/regular points can be labeled. The Breusch-Pagan test for heteroskedasticity is run and, if enabled, its p-value annotates the plot.
}
\examples{
mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
lm_plot.var(mdl, pval.BP = TRUE)

}
\seealso{
\code{\link{lm_plot.df}}, \code{\link{lm_plot.parms}}, \code{\link[lmtest]{bptest}}
}
