% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kemna_vorst_arithmetic.R
\name{price_kemna_vorst_arithmetic}
\alias{price_kemna_vorst_arithmetic}
\title{Kemna-Vorst Arithmetic Average Asian Option}
\usage{
price_kemna_vorst_arithmetic(
  S0,
  K,
  r,
  sigma,
  T0,
  T_mat,
  n,
  M = 10000,
  option_type = "call",
  use_control_variate = TRUE,
  seed = NULL,
  return_diagnostics = FALSE
)
}
\arguments{
\item{S0}{Numeric. Initial stock price at time T0 (start of averaging period).
Must be positive.}

\item{K}{Numeric. Strike price. Must be positive.}

\item{r}{Numeric. Continuously compounded risk-free rate (e.g., 0.05 for 5\%).
Use \code{log(r_gross)} to convert from gross rate.}

\item{sigma}{Numeric. Volatility (annualized standard deviation). Must be
non-negative.}

\item{T0}{Numeric. Start time of averaging period. Must be non-negative.}

\item{T_mat}{Numeric. Maturity time. Must be greater than T0.}

\item{n}{Integer. Number of averaging points (observations). Must be positive.}

\item{M}{Integer. Number of Monte Carlo simulations. Default is 10000.
Larger values give more accurate results but take longer.}

\item{option_type}{Character. Type of option: "call" (default) or "put".}

\item{use_control_variate}{Logical. If TRUE (default), uses the geometric
average as a control variate for variance reduction. This dramatically
improves accuracy.}

\item{seed}{Integer. Random seed for reproducibility. Default is NULL (no seed).}

\item{return_diagnostics}{Logical. If TRUE, returns additional diagnostic
information including confidence intervals, correlation, and variance
reduction factor. Default is FALSE.}
}
\value{
If \code{return_diagnostics = FALSE}, returns a numeric value (the
  estimated option price). If \code{return_diagnostics = TRUE}, returns a list with components:
  \describe{
    \item{price}{Estimated option price}
    \item{std_error}{Standard error of the estimate}
    \item{lower_ci}{Lower 95\% confidence interval}
    \item{upper_ci}{Upper 95\% confidence interval}
    \item{geometric_price}{Analytical geometric average price (control variate)}
    \item{correlation}{Correlation between arithmetic and geometric payoffs}
    \item{variance_reduction_factor}{Ratio of variances (with/without control)}
    \item{n_simulations}{Number of Monte Carlo simulations used}
    \item{n_steps}{Number of time steps in each simulation}
  }
}
\description{
Calculates the price of an arithmetic average Asian option using Monte Carlo
simulation with variance reduction via the geometric average control variate.
This implements the Kemna & Vorst (1990) method WITHOUT price impact.
}
\examples{
price_kemna_vorst_arithmetic(
  S0 = 100, K = 100, r = 0.05, sigma = 0.2,
  T0 = 0, T_mat = 1, n = 50, M = 10000
)

}
\references{
Kemna, A.G.Z. and Vorst, A.C.F. (1990). "A Pricing Method for Options Based
on Average Asset Values." \emph{Journal of Banking and Finance}, 14, 113-129.
}
