% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgXReplicationFactory.R
\name{sgXReplicationFactory}
\alias{sgXReplicationFactory}
\title{Factory for configuring a gene-dependent Replication function.}
\usage{
sgXReplicationFactory(algorithm = "sga", method = "Kid1")
}
\arguments{
\item{algorithm}{Algorithm. 
Available: "sga", "sgde", "sgperm", "sge", "sgede", sgp". 
Default: "sga".}

\item{method}{Method. 
                 
                 Options are package-dependent:
  \itemize{
   \item "sga", "sgperm", "sge", sgp": 
      "Kid1", "KidPipeline", "Kid2".
   \item "sgde", "sgede": 
      "DE", "DEPipeline".
}}
}
\value{
A replication function for the algorithm from the correct package.
}
\description{
Factory for configuring a gene-dependent Replication function.
}
\examples{
sgXReplicationFactory(algorithm="sgp", method="Kid1")

}
\seealso{
Other Configuration: 
\code{\link{sgXCrossoverFactory}()},
\code{\link{sgXDecodeGeneFactory}()},
\code{\link{sgXGeneMapFactory}()},
\code{\link{sgXInitGeneFactory}()},
\code{\link{sgXMutationFactory}()}
}
\concept{Configuration}
