% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{m_Opensearch}
\alias{m_Opensearch}
\title{Open search of a string}
\usage{
m_Opensearch(
  string,
  project = "en.wikipedia.org",
  profile = "engine_autoselect",
  redirects = "resolve"
)
}
\arguments{
\item{string}{String to search.}

\item{project}{Wikimedia project, defaults "en.wikipedio.org".}

\item{profile}{This parameter sets the search type: classic,
engine_autoselect (default), fast-fuzzy, fuzzy, fuzzy-subphrases, normal,
normal-subphrases, and strict.}

\item{redirects}{If redirects='return', the page title is the normalized one
(also the URL). If redirects='resolve", the page title is the normalized and
resolved redirection is in effect (also the URL). Note that in both cases the
API performs a NFC Unicode normalization on search string.}
}
\value{
A data-frame of page titles and URL returned. If error, return Null.
}
\description{
Search string in the content of the project page using OpenSearch. Only in
namespace 0. Please, see https://www.mediawiki.org/wiki/API:Opensearch for
further information.
}
\note{
Only for namespace 0. The function also obtains redirections for
disambiguation pages.
}
\examples{
# Some search profiles:
df <- m_Opensearch(string='Duque de Alba', project='es.wikipedia.org',
                    profile="engine_autoselect", redirects="resolve")
df <- m_Opensearch(string='Duque de Alba', project='es.wikipedia.org', profile="strict")
df <- m_Opensearch(string='Duque de Alba', project='es.wikipedia.org', profile="fuzzy")
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
