% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom_fwf.R
\name{vroom_fwf}
\alias{vroom_fwf}
\alias{fwf_empty}
\alias{fwf_widths}
\alias{fwf_positions}
\alias{fwf_cols}
\title{Read a fixed width file into a tibble}
\usage{
vroom_fwf(
  file,
  col_positions = fwf_empty(file, skip, n = guess_max),
  col_types = NULL,
  col_select = NULL,
  id = NULL,
  locale = default_locale(),
  na = c("", "NA"),
  comment = "",
  skip_empty_rows = TRUE,
  trim_ws = TRUE,
  skip = 0,
  n_max = Inf,
  guess_max = 100,
  altrep = TRUE,
  altrep_opts = deprecated(),
  num_threads = vroom_threads(),
  progress = vroom_progress(),
  show_col_types = NULL,
  .name_repair = "unique"
)

fwf_empty(file, skip = 0, col_names = NULL, comment = "", n = 100L)

fwf_widths(widths, col_names = NULL)

fwf_positions(start, end = NULL, col_names = NULL)

fwf_cols(...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, the input must be either wrapped with \code{I()}, be a string
containing at least one new line, or be a vector containing at least one
string with a new line.

Using a value of \code{\link[readr:clipboard]{clipboard()}} will read from the system clipboard.}

\item{col_positions}{Column positions, as created by \code{\link[readr:fwf_empty]{fwf_empty()}},
\code{\link[readr:fwf_widths]{fwf_widths()}} or \code{\link[readr:fwf_positions]{fwf_positions()}}. To read in only selected fields,
use \code{\link[readr:fwf_positions]{fwf_positions()}}. If the width of the last column is variable (a
ragged fwf file), supply the last end position as NA.}

\item{col_types}{One of \code{NULL}, a \code{\link[readr:cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be inferred from \code{guess_max} rows of the
input, interspersed throughout the file. This is convenient (and fast),
but not robust. If the guessed types are wrong, you'll need to increase
\code{guess_max} or supply the correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[readr:cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[readr:cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip
}

By default, reading a file without a column specification will print a
message showing what \code{readr} guessed they were. To remove this message,
set \code{show_col_types = FALSE} or set \code{options(readr.show_col_types = FALSE)}.}

\item{col_select}{Columns to include in the results. You can use the same
mini-language as \code{dplyr::select()} to refer to the columns by name. Use
\code{c()} to use more than one selection expression. Although this
usage is less common, \code{col_select} also accepts a numeric column index. See
\code{\link[tidyselect:language]{?tidyselect::language}} for full details on the
selection language.}

\item{id}{The name of a column in which to store the file path. This is
useful when reading multiple input files and there is data in the file
paths, such as the data collection date. If \code{NULL} (the default) no extra
column is created.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[readr:locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of lines to read.}

\item{guess_max}{Maximum number of lines to use for guessing column types.
Will never use more than the number of lines read.
See \code{vignette("column-types", package = "readr")} for more details.}

\item{altrep}{Control which column types use Altrep representations,
either a character vector of types, \code{TRUE} or \code{FALSE}. See
\code{\link[=vroom_altrep]{vroom_altrep()}} for for full details.}

\item{altrep_opts}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}}

\item{num_threads}{The number of processing threads to use for initial
parsing and lazy reading of data. If your data contains newlines within
fields the parser should automatically detect this and fall back to using
one thread only. However if you know your file has newlines within quoted
fields it is safest to set \code{num_threads = 1} explicitly.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The automatic
progress bar can be disabled by setting option \code{readr.show_progress} to
\code{FALSE}.}

\item{show_col_types}{If \code{FALSE}, do not show the guessed column types. If
\code{TRUE} always show the column types, even if they are supplied. If \code{NULL}
(the default) only show the column types if they are not explicitly supplied
by the \code{col_types} argument.}

\item{.name_repair}{Handling of column names. The default behaviour is to
ensure column names are \code{"unique"}. Various repair strategies are
supported:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence of names.
\item \code{"unique"} (default value): Make sure names are unique and not empty.
\item \code{"check_unique"}: No name repair, but check they are \code{unique}.
\item \code{"unique_quiet"}: Repair with the \code{unique} strategy, quietly.
\item \code{"universal"}: Make the names \code{unique} and syntactic.
\item \code{"universal_quiet"}: Repair with the \code{universal} strategy, quietly.
\item A function: Apply custom name repair (e.g., \code{name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}.
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}

\item{col_names}{Either NULL, or a character vector column names.}

\item{n}{Number of lines the tokenizer will read to determine file structure. By default
it is set to 100.}

\item{widths}{Width of each field. Use NA as width of last field when
reading a ragged fwf file.}

\item{start, end}{Starting and ending (inclusive) positions of each field.
Use NA as last end field when reading a ragged fwf file.}

\item{...}{If the first element is a data frame,
then it must have all numeric columns and either one or two rows.
The column names are the variable names. The column values are the
variable widths if a length one vector, and if length two, variable start and end
positions. The elements of \code{...} are used to construct a data frame
with or or two rows as above.}
}
\description{
Read a fixed width file into a tibble
}
\details{
\emph{Note}: \code{fwf_empty()} cannot take a R connection such as a URL as input, as
this would result in reading from the connection twice. In these cases it is
better to download the file first before reading.
}
\examples{
fwf_sample <- vroom_example("fwf-sample.txt")
writeLines(vroom_lines(fwf_sample))

# You can specify column positions in several ways:
# 1. Guess based on position of empty columns
vroom_fwf(fwf_sample, fwf_empty(fwf_sample, col_names = c("first", "last", "state", "ssn")))
# 2. A vector of field widths
vroom_fwf(fwf_sample, fwf_widths(c(20, 10, 12), c("name", "state", "ssn")))
# 3. Paired vectors of start and end positions
vroom_fwf(fwf_sample, fwf_positions(c(1, 30), c(20, 42), c("name", "ssn")))
# 4. Named arguments with start and end positions
vroom_fwf(fwf_sample, fwf_cols(name = c(1, 20), ssn = c(30, 42)))
# 5. Named arguments with column widths
vroom_fwf(fwf_sample, fwf_cols(name = 20, state = 10, ssn = 12))
}
