% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAbundance.R
\name{getAbundance}
\alias{getAbundance}
\title{Calculate abundance}
\usage{
getAbundance(
  collections,
  interval,
  agency = NULL,
  species = NULL,
  trap = NULL,
  sex = "female",
  trapnight_min = 1,
  trapnight_max = NULL,
  separate_by = NULL
)
}
\arguments{
\item{collections}{Collections data retrieved from getArthroCollections()}

\item{interval}{Calculation interval for abundance, accepts "CollectionDate","Week", "Biweek", or "Month.}

\item{agency}{An optional vector for filtering agency by character code}

\item{species}{Character vector for filtering species. View species in your data `unique(data$species_display_name)`. Defaults to all species if no selection}

\item{trap}{Character vector for filtering trap type by acronym. View trap types in your data`unique(data$trap_acronym`. Defaults to all trap types}

\item{sex}{Character vector for filtering sex type. View sex options `unique(data$sex_type`). Defaults to "female".}

\item{trapnight_min}{Minimum trap night restriction for calculation. Default is 1.}

\item{trapnight_max}{Maximum trap night restriction for calculation. Default is no restriction.}

\item{separate_by}{Separate/group the calculation by 'trap','species', 'agency', 'county', or 'spatial'. Default NULL does not separate.}
}
\value{
A dataframe of abundance calculations.
}
\description{
Calculates abundance with option for filtering data and grouping
results
}
\examples{
getAbundance(sample_collections,
             interval = 'Week',
             species = list('Cx pipiens'),
             trap = list('GRVD', 'CO2'),
             sex = list("female"),
             trapnight_min = 1,
             trapnight_max = 5,
             separate_by  = "species")
}
