% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submission_functions.R
\docType{data}
\name{submission_server}
\alias{submission_server}
\alias{submission_ui}
\title{Tutorial submission functions}
\format{
An object of class \code{shiny.tag} of length 3.
}
\usage{
submission_server()

submission_ui
}
\value{
No return value; called for side effects in a Shiny/learnr session.

An object of class shiny.tag
}
\description{
Provides the core Shiny server and UI hooks for collecting and downloading student answers
from a learnr tutorial. \code{submission_server()} should be called in an Rmd code chunk with
\code{context="server"}.

This function was modified from Colin Rundel's learnrhash package
(https://github.com/rundel/learnrhash).

UI block to include a download button and simple instructions for students.
}
\details{
The server function uses a Shiny downloadHandler to let students download their answers.
All main logic must be wrapped in \code{local()} with \code{parent.frame()} to ensure access to the live
learnr session and objects created in the parent environment.

The \code{session} object (created by Shiny) is only available inside the \code{downloadHandler$content}
function, so any test-case extraction or answer writing must happen there.

For reference: the \code{file} argument in \code{content} is a temporary file path created by Shiny,
and your handler's job is to write the downloadable file there.

If you want to generate test fixtures, insert \code{browser()} inside the \code{content} function,
then use functions like \code{get_submissions_from_learnr_session(session)} at the prompt.

See also: https://mastering-shiny.org/action-transfer.html#downloading-reports
}
\examples{
if(interactive()){
  submission_server()
}

if(interactive()){
  submission_ui
}

}
\keyword{datasets}
