% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_spline.R
\name{ts_fil_spline}
\alias{ts_fil_spline}
\title{Smoothing Splines}
\usage{
ts_fil_spline(spar = NULL)
}
\arguments{
\item{spar}{smoothing parameter. When spar is specified, the coefficient
of the integral of the squared second derivative in the fitting criterion (penalized log-likelihood)
is a monotone function of spar.
#'@return a \code{ts_fil_spline} object.}
}
\description{
Fits a cubic smoothing spline to a time series.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_spline(spar = 0.5)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
