% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-inception.R
\name{model_inception_v3}
\alias{model_inception_v3}
\title{Inception v3 model}
\usage{
model_inception_v3(pretrained = FALSE, progress = TRUE, ...)
}
\arguments{
\item{pretrained}{(bool): If \code{TRUE}, returns a model pre-trained on ImageNet}

\item{progress}{(bool): If \code{TRUE}, displays a progress bar of the download to stderr}

\item{...}{Used to pass keyword arguments to the Inception module:
\itemize{
\item aux_logits (bool): If \code{TRUE}, add an auxiliary branch that can improve training.
Default: \emph{TRUE}
\item transform_input (bool): If \code{TRUE}, preprocess the input according to the method with which it
was trained on ImageNet. Default: \emph{FALSE}
}}
}
\description{
Architecture from \href{https://arxiv.org/abs/1512.00567}{Rethinking the Inception Architecture for Computer Vision}
The required minimum input size of the model is 75x75.
}
\note{
\strong{Important}: In contrast to the other models the inception_v3 expects tensors with a size of
N x 3 x 299 x 299, so ensure your images are sized accordingly.
}
\seealso{
Other models: 
\code{\link{model_alexnet}()},
\code{\link{model_mobilenet_v2}()},
\code{\link{model_resnet}},
\code{\link{model_vgg}}
}
\concept{models}
