% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDRectangle.R
\name{tiledb_ndrectangle_datatype_by_ind}
\alias{tiledb_ndrectangle_datatype_by_ind}
\title{Get the datatype of a \code{tiledb_ndrectangle} dimension by index}
\usage{
tiledb_ndrectangle_datatype_by_ind(ndr, dim)
}
\arguments{
\item{ndr}{A TileDB NDRectangle object}

\item{dim}{Am integer value for the dimension for which to get a datatype}
}
\value{
The \code{tiledb_ndrectangle} dimension datatype as a character
}
\description{
Get the datatype of a \code{tiledb_ndrectangle} dimension by index
}
\examples{
\dontshow{
ctx <- tiledb_ctx(limitTileDBCores())
}
if (tiledb_version(TRUE) >= "2.26.0") {
  dom <- tiledb_domain(dim = tiledb_dim("d1", c(1L, 100L), type = "INT32"))
  ndr <- tiledb_ndrectangle(dom)
  tiledb_ndrectangle_datatype_by_ind(ndr, 0)
}
}
