% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_gt_pca.R
\name{autoplot_gt_pca}
\alias{autoplot_gt_pca}
\alias{autoplot.gt_pca}
\title{Autoplots for \code{gt_pca} objects}
\usage{
\method{autoplot}{gt_pca}(object, type = c("screeplot", "scores", "loadings"), k = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{gt_pca}}

\item{type}{the type of plot (one of "screeplot", "scores" and "loadings")}

\item{k}{the principal components to be plotted: for scores, a pair of values
e.g. c(1,2); for \code{loadings} either one or more values.}

\item{...}{not currently used.}
}
\value{
a \code{ggplot2} object
}
\description{
For \code{gt_pca}, the following types of plots are available:
\itemize{
\item \code{screeplot}: a plot of the eigenvalues of the principal components
(currently it plots the singular value)
\item \code{scores} a scatterplot of the scores of each individual on two principal
components (defined by \code{pc})
\item \code{loadings} a plot of loadings of all loci for a given component
(chosen with \code{pc})
}
}
\details{
\code{autoplot} produces simple plots to quickly inspect an object. They are not
customisable; we recommend that you use \code{ggplot2} to produce publication
ready plots.
}
\examples{
library(ggplot2)
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA object
pca <- gt_pca_partialSVD(lobsters)

# Screeplot
autoplot(pca, type = "screeplot")

# Scores plot
autoplot(pca, type = "scores")

# Colour by population
autoplot(pca, type = "scores") + aes(colour = lobsters$population)

# Scores plot of different components
autoplot(pca, type = "scores", k = c(1, 3)) +
  aes(colour = lobsters$population)
}
