% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_levels.R
\name{reorder_x_axis_levels}
\alias{reorder_x_axis_levels}
\alias{reorder_y_axis_levels}
\alias{reorder_color_levels}
\alias{reorder_x_axis_labels}
\alias{reorder_y_axis_labels}
\alias{reorder_color_labels}
\title{Reorder axis or color levels}
\usage{
reorder_x_axis_levels(plot, ...)

reorder_y_axis_levels(plot, ...)

reorder_color_levels(plot, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{...}{Arguments passed on to \code{forcats::fct_relevel()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Reorder axis or color levels
}
\examples{
# Before adjustments
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reorder x-axis levels
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reorder_x_axis_levels("D", "B", "A")

# Before adjustments
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reorder y-axis levels
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reorder_y_axis_levels("D", "B", "A")

# Before adjustment
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Reorder color levels
study |>
  tidyplot(x = group, y = score, color = dose) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  reorder_color_levels("low")

}
