% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_cga.R
\name{segment_cga}
\alias{segment_cga}
\title{Segment a time series using a genetic algorithm}
\usage{
segment_cga(x, ...)
}
\arguments{
\item{x}{A time series}

\item{...}{arguments passed to \code{\link[changepointGA:GA]{changepointGA::GA()}}}
}
\value{
A \code{cga} object. This is just a \code{\link[changepointGA:GA]{changepointGA::GA()}}
object with an additional
slot for \code{data} (the original time series).
}
\description{
Segmenting functions for various genetic algorithms
}
\details{
\code{\link[=segment_cga]{segment_cga()}} uses the genetic algorithm in \code{\link[GA:ga]{GA::ga()}} to "evolve" a random
set of candidate changepoint sets, using the penalized objective function
specified by \code{penalty_fn}.
By default, the normal \code{meanshift} model is fit (see \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}})
and the \link{BIC} penalty is applied.
}
\examples{
\donttest{
# Segment a time series using a genetic algorithm
res <- segment_cga(CET)
summary(res)

# Segment a time series using changepointGA
x <- segment(CET, method = "cga")
summary(x)
changepoints(x)
}
}
