% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesECDF.R
\name{genesECDF}
\alias{genesECDF}
\title{Compute ECDF for Genes Based on Expression Data}
\usage{
genesECDF(allexprsdfs, expdf, nbcpu = 1, rounding = 10,
showtime = FALSE, verbose = TRUE)
}
\arguments{
\item{allexprsdfs}{A list of data frames where the first element is the main
expression data frame and the second element contains the names of the
expressed transcripts (see 'averageandfilterexprs').}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{nbcpu}{An integer specifying the number of CPU cores to use for
parallel computation. Default is \code{1}.}

\item{rounding}{An integer specifying the rounding factor for computing ECDF.
Default is \code{10}.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{verbose}{A logical flag indicating whether to print progress messages.
Default is \code{TRUE}.}
}
\value{
A list containing two elements:
\item{concatdf}{A data frame with ECDF results for each transcript.}
\item{nbrows}{An integer indicating the number of rows in each transcript
 table.}
}
\description{
This function calculates the empirical cumulative distribution function
(ECDF) for expressed genes across multiple transcripts. It processes the
expression data to filter out non-expressed transcripts, compute ECDF values
for each transcript, and combine the results into a unified data frame. The
function operates in parallel for speed optimization.
}
\details{
The function performs several steps:
\enumerate{
  \item Filters the main expression table to retain only the expressed
     transcripts.
  \item Splits the data by each transcript.
  \item For each transcript, computes ECDF values for the score columns
     while respecting the strand orientation ("plus" or "minus").
  \item Combines the ECDF results into a final data frame.
}

The function uses parallel processing to compute ECDF for each transcript
 simultaneously, making it faster on systems with multiple CPU cores.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Calculating averageandfilterexprs and countNA to call genesECDF
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)
avfilttest <- averageandfilterexprs(expdf, transdf, expthres,
        showtime = FALSE, verbose = FALSE)
countnatest <- countna(avfilttest, expdf, nbcpu = 1, verbose = FALSE)

## Testing genesECDF 
resecdf <- genesECDF(avfilttest, expdf, verbose = FALSE)

}
\seealso{
[averageandfilterexprs]
}
