% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discount_vector.R
\name{discount_vector}
\alias{discount_vector}
\title{A function to create a discount vector for a given time period}
\usage{
discount_vector(
  discount_rate = 0.03,
  start_time = 0,
  end_time,
  time_unit = c("years", "months", "weeks", "days"),
  discount_year_one = FALSE
)
}
\arguments{
\item{discount_rate}{The discount rate to use for the calculation. Default is 0.03. The guideline stipulates 0.03 for costs and 0.015 for effects.}

\item{start_time}{The start time for the discount vector. Default is 0.}

\item{end_time}{The end time for the discount vector.}

\item{time_unit}{The unit of time to use for the calculation. Default is "years", but "months", "weeks", and "days" are also valid options.}

\item{discount_year_one}{Logical value indicating whether to discount the first year as well. Default is FALSE.}
}
\value{
A numeric vector of discounted values for each time period.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A function to calculate a discount vector for a given time period based on the in paragraph 2.6.1.2 of the Dutch EE guideline mentioned discount rate and time period
}
\examples{
# Example usage of the discount_vector function
# Calculate the discount vector for 5 years, a discount rate of 0.015, first year is not discounted
discount_vector(discount_rate = 0.015, end_time = 5, time_unit = "years")

# Calculate the discount vector for 60 months, a start time of 2, the first year is not discounted
discount_vector(discount_rate = 0.03, start_time = 2, end_time = 60, time_unit = "months")

# Calculate the discount vector for 365 days, a discount rate of 0.06, the first year is discounted
discount_vector(discount_rate = 0.06, end_time = 365, time_unit = "days", discount_year_one = TRUE)

}
\keyword{Costs}
\keyword{Discounting}
\keyword{Effects}
