% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_alive}
\alias{add_alive}
\title{Adds alive flag}
\usage{
add_alive(df, .ep, .at = "end")
}
\arguments{
\item{df}{Data frame. Must contain \code{version_season} and \code{castaway}.}

\item{.ep}{Episode to evaluate the flag.}

\item{.at}{Either 'start' or 'end'. If 'start' the flag will indicate who is
alive at the start of the episode. If 'end' it will indicate who is alive at
the end of the episode i.e. after tribal council.}
}
\value{
A data frame with a new column \code{alive}.
}
\description{
Adds a logical flag if the castaway is alive at the start or end of an episode
}
\examples{

library(survivoR)
library(dplyr)

df <- confessionals |>
  filter_us(47) |>
  add_alive(12)

df |>
  filter(alive) |>
  group_by(castaway) |>
  summarise(n = sum(confessional_count))
}
