% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_buffer.R
\name{create_buffer}
\alias{create_buffer}
\title{Expand points to extend beyond the outermost centroids}
\usage{
create_buffer(centroids, grid, hex_size, buffer_dist, verbose = FALSE)
}
\arguments{
\item{centroids}{data frame of centroids to be allocated}

\item{grid}{data frame of hexagon centroids}

\item{hex_size}{a float value in degrees for the diameter of the hexagons}

\item{buffer_dist}{distance to extend beyond the geometry provided}

\item{verbose}{a boolean to indicate whether to show function progress}
}
\value{
data frame of hexagon centroids
}
\description{
Called from within create_grid function, this function takes the bounding
box of a group of polygons, or a specific table of minimum and maximum
longitudes and latitudes to create points for each polygon to be allocated
to that will tessellate into hexagons.
}
\examples{
lga_centroids <- create_centroids(sugarbag::tas_lga, "lga_code_2016")
lga_grid <- create_grid(lga_centroids, hex_size = 0.2, buffer_dist = 1.2)

}
