% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{ForestModelConfig}
\alias{ForestModelConfig}
\title{Object used to get / set parameters and other model configuration options
for a forest model in the "low-level" stochtree interface}
\value{
Vector of integer-coded feature types (integers where 0 = numeric, 1 = ordered categorical, 2 = unordered categorical)

Vector specifying sampling probability for all p covariates in ForestDataset

Root node split probability in tree prior

Depth prior penalty in tree prior

Minimum number of samples in a tree leaf

Maximum depth of any tree in the ensemble in the model

Scale parameter used in Gaussian leaf models

Shape parameter for IG leaf models

Scale parameter for IG leaf models

Number of unique cutpoints to consider
}
\description{
The "low-level" stochtree interface enables a high degreee of sampler
customization, in which users employ R wrappers around C++ objects
like ForestDataset, Outcome, CppRng, and ForestModel to run the
Gibbs sampler of a BART model with custom modifications.
ForestModelConfig allows users to specify / query the parameters of a
forest model they wish to run.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{feature_types}}{Vector of integer-coded feature types (integers where 0 = numeric, 1 = ordered categorical, 2 = unordered categorical)}

\item{\code{num_trees}}{Number of trees in the forest being sampled}

\item{\code{num_features}}{Number of features in training dataset}

\item{\code{num_observations}}{Number of observations in training dataset}

\item{\code{leaf_dimension}}{Dimension of the leaf model}

\item{\code{alpha}}{Root node split probability in tree prior}

\item{\code{beta}}{Depth prior penalty in tree prior}

\item{\code{min_samples_leaf}}{Minimum number of samples in a tree leaf}

\item{\code{max_depth}}{Maximum depth of any tree in the ensemble in the model. Setting to \code{-1} does not enforce any depth limits on trees.}

\item{\code{leaf_model_type}}{Integer specifying the leaf model type (0 = constant leaf, 1 = univariate leaf regression, 2 = multivariate leaf regression)}

\item{\code{leaf_model_scale}}{Scale parameter used in Gaussian leaf models}

\item{\code{variable_weights}}{Vector specifying sampling probability for all p covariates in ForestDataset}

\item{\code{variance_forest_shape}}{Shape parameter for IG leaf models (applicable when \code{leaf_model_type = 3})}

\item{\code{variance_forest_scale}}{Scale parameter for IG leaf models (applicable when \code{leaf_model_type = 3})}

\item{\code{cutpoint_grid_size}}{Number of unique cutpoints to consider
Create a new ForestModelConfig object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ForestModelConfig-new}{\code{ForestModelConfig$new()}}
\item \href{#method-ForestModelConfig-update_feature_types}{\code{ForestModelConfig$update_feature_types()}}
\item \href{#method-ForestModelConfig-update_variable_weights}{\code{ForestModelConfig$update_variable_weights()}}
\item \href{#method-ForestModelConfig-update_alpha}{\code{ForestModelConfig$update_alpha()}}
\item \href{#method-ForestModelConfig-update_beta}{\code{ForestModelConfig$update_beta()}}
\item \href{#method-ForestModelConfig-update_min_samples_leaf}{\code{ForestModelConfig$update_min_samples_leaf()}}
\item \href{#method-ForestModelConfig-update_max_depth}{\code{ForestModelConfig$update_max_depth()}}
\item \href{#method-ForestModelConfig-update_leaf_model_scale}{\code{ForestModelConfig$update_leaf_model_scale()}}
\item \href{#method-ForestModelConfig-update_variance_forest_shape}{\code{ForestModelConfig$update_variance_forest_shape()}}
\item \href{#method-ForestModelConfig-update_variance_forest_scale}{\code{ForestModelConfig$update_variance_forest_scale()}}
\item \href{#method-ForestModelConfig-update_cutpoint_grid_size}{\code{ForestModelConfig$update_cutpoint_grid_size()}}
\item \href{#method-ForestModelConfig-get_feature_types}{\code{ForestModelConfig$get_feature_types()}}
\item \href{#method-ForestModelConfig-get_variable_weights}{\code{ForestModelConfig$get_variable_weights()}}
\item \href{#method-ForestModelConfig-get_alpha}{\code{ForestModelConfig$get_alpha()}}
\item \href{#method-ForestModelConfig-get_beta}{\code{ForestModelConfig$get_beta()}}
\item \href{#method-ForestModelConfig-get_min_samples_leaf}{\code{ForestModelConfig$get_min_samples_leaf()}}
\item \href{#method-ForestModelConfig-get_max_depth}{\code{ForestModelConfig$get_max_depth()}}
\item \href{#method-ForestModelConfig-get_leaf_model_scale}{\code{ForestModelConfig$get_leaf_model_scale()}}
\item \href{#method-ForestModelConfig-get_variance_forest_shape}{\code{ForestModelConfig$get_variance_forest_shape()}}
\item \href{#method-ForestModelConfig-get_variance_forest_scale}{\code{ForestModelConfig$get_variance_forest_scale()}}
\item \href{#method-ForestModelConfig-get_cutpoint_grid_size}{\code{ForestModelConfig$get_cutpoint_grid_size()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$new(
  feature_types = NULL,
  num_trees = NULL,
  num_features = NULL,
  num_observations = NULL,
  variable_weights = NULL,
  leaf_dimension = 1,
  alpha = 0.95,
  beta = 2,
  min_samples_leaf = 5,
  max_depth = -1,
  leaf_model_type = 1,
  leaf_model_scale = NULL,
  variance_forest_shape = 1,
  variance_forest_scale = 1,
  cutpoint_grid_size = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_types}}{Vector of integer-coded feature types (integers where 0 = numeric, 1 = ordered categorical, 2 = unordered categorical)}

\item{\code{num_trees}}{Number of trees in the forest being sampled}

\item{\code{num_features}}{Number of features in training dataset}

\item{\code{num_observations}}{Number of observations in training dataset}

\item{\code{variable_weights}}{Vector specifying sampling probability for all p covariates in ForestDataset}

\item{\code{leaf_dimension}}{Dimension of the leaf model (default: \code{1})}

\item{\code{alpha}}{Root node split probability in tree prior (default: \code{0.95})}

\item{\code{beta}}{Depth prior penalty in tree prior (default: \code{2.0})}

\item{\code{min_samples_leaf}}{Minimum number of samples in a tree leaf (default: \code{5})}

\item{\code{max_depth}}{Maximum depth of any tree in the ensemble in the model. Setting to \code{-1} does not enforce any depth limits on trees. Default: \code{-1}.}

\item{\code{leaf_model_type}}{Integer specifying the leaf model type (0 = constant leaf, 1 = univariate leaf regression, 2 = multivariate leaf regression). Default: \code{0}.}

\item{\code{leaf_model_scale}}{Scale parameter used in Gaussian leaf models (can either be a scalar or a q x q matrix, where q is the dimensionality of the basis and is only >1 when \code{leaf_model_int = 2}). Calibrated internally as \code{1/num_trees}, propagated along diagonal if needed for multivariate leaf models.}

\item{\code{variance_forest_shape}}{Shape parameter for IG leaf models (applicable when \code{leaf_model_type = 3}). Default: \code{1}.}

\item{\code{variance_forest_scale}}{Scale parameter for IG leaf models (applicable when \code{leaf_model_type = 3}). Default: \code{1}.}

\item{\code{cutpoint_grid_size}}{Number of unique cutpoints to consider (default: \code{100})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new ForestModelConfig object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_feature_types"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_feature_types}{}}}
\subsection{Method \code{update_feature_types()}}{
Update feature types
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_feature_types(feature_types)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_types}}{Vector of integer-coded feature types (integers where 0 = numeric, 1 = ordered categorical, 2 = unordered categorical)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_variable_weights"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_variable_weights}{}}}
\subsection{Method \code{update_variable_weights()}}{
Update variable weights
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_variable_weights(variable_weights)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variable_weights}}{Vector specifying sampling probability for all p covariates in ForestDataset}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_alpha}{}}}
\subsection{Method \code{update_alpha()}}{
Update root node split probability in tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_alpha(alpha)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{Root node split probability in tree prior}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_beta"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_beta}{}}}
\subsection{Method \code{update_beta()}}{
Update depth prior penalty in tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_beta(beta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Depth prior penalty in tree prior}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_min_samples_leaf"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_min_samples_leaf}{}}}
\subsection{Method \code{update_min_samples_leaf()}}{
Update root node split probability in tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_min_samples_leaf(min_samples_leaf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_samples_leaf}}{Minimum number of samples in a tree leaf}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_max_depth}{}}}
\subsection{Method \code{update_max_depth()}}{
Update root node split probability in tree prior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_max_depth(max_depth)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_depth}}{Maximum depth of any tree in the ensemble in the model}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_leaf_model_scale"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_leaf_model_scale}{}}}
\subsection{Method \code{update_leaf_model_scale()}}{
Update scale parameter used in Gaussian leaf models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_leaf_model_scale(leaf_model_scale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leaf_model_scale}}{Scale parameter used in Gaussian leaf models}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_variance_forest_shape"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_variance_forest_shape}{}}}
\subsection{Method \code{update_variance_forest_shape()}}{
Update shape parameter for IG leaf models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_variance_forest_shape(variance_forest_shape)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variance_forest_shape}}{Shape parameter for IG leaf models}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_variance_forest_scale"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_variance_forest_scale}{}}}
\subsection{Method \code{update_variance_forest_scale()}}{
Update scale parameter for IG leaf models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_variance_forest_scale(variance_forest_scale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variance_forest_scale}}{Scale parameter for IG leaf models}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-update_cutpoint_grid_size"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-update_cutpoint_grid_size}{}}}
\subsection{Method \code{update_cutpoint_grid_size()}}{
Update number of unique cutpoints to consider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$update_cutpoint_grid_size(cutpoint_grid_size)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutpoint_grid_size}}{Number of unique cutpoints to consider}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_feature_types"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_feature_types}{}}}
\subsection{Method \code{get_feature_types()}}{
Query feature types for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_feature_types()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_variable_weights"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_variable_weights}{}}}
\subsection{Method \code{get_variable_weights()}}{
Query variable weights for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_variable_weights()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_alpha}{}}}
\subsection{Method \code{get_alpha()}}{
Query root node split probability in tree prior for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_alpha()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_beta"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_beta}{}}}
\subsection{Method \code{get_beta()}}{
Query depth prior penalty in tree prior for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_beta()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_min_samples_leaf"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_min_samples_leaf}{}}}
\subsection{Method \code{get_min_samples_leaf()}}{
Query root node split probability in tree prior for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_min_samples_leaf()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_max_depth}{}}}
\subsection{Method \code{get_max_depth()}}{
Query root node split probability in tree prior for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_max_depth()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_leaf_model_scale"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_leaf_model_scale}{}}}
\subsection{Method \code{get_leaf_model_scale()}}{
Query scale parameter used in Gaussian leaf models for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_leaf_model_scale()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_variance_forest_shape"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_variance_forest_shape}{}}}
\subsection{Method \code{get_variance_forest_shape()}}{
Query shape parameter for IG leaf models for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_variance_forest_shape()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_variance_forest_scale"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_variance_forest_scale}{}}}
\subsection{Method \code{get_variance_forest_scale()}}{
Query scale parameter for IG leaf models for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_variance_forest_scale()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestModelConfig-get_cutpoint_grid_size"></a>}}
\if{latex}{\out{\hypertarget{method-ForestModelConfig-get_cutpoint_grid_size}{}}}
\subsection{Method \code{get_cutpoint_grid_size()}}{
Query number of unique cutpoints to consider for this ForestModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestModelConfig$get_cutpoint_grid_size()}\if{html}{\out{</div>}}
}

}
}
