% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{Forest}
\alias{Forest}
\title{Class that stores a single ensemble of decision trees (often treated as the "active forest")}
\description{
Wrapper around a C++ tree ensemble
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{forest_ptr}}{External pointer to a C++ TreeEnsemble class}

\item{\code{internal_forest_is_empty}}{Whether the forest has not yet been "initialized" such that its \code{predict} function can be called.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Forest-new}{\code{Forest$new()}}
\item \href{#method-Forest-predict}{\code{Forest$predict()}}
\item \href{#method-Forest-predict_raw}{\code{Forest$predict_raw()}}
\item \href{#method-Forest-set_root_leaves}{\code{Forest$set_root_leaves()}}
\item \href{#method-Forest-prepare_for_sampler}{\code{Forest$prepare_for_sampler()}}
\item \href{#method-Forest-adjust_residual}{\code{Forest$adjust_residual()}}
\item \href{#method-Forest-num_trees}{\code{Forest$num_trees()}}
\item \href{#method-Forest-leaf_dimension}{\code{Forest$leaf_dimension()}}
\item \href{#method-Forest-is_constant_leaf}{\code{Forest$is_constant_leaf()}}
\item \href{#method-Forest-is_exponentiated}{\code{Forest$is_exponentiated()}}
\item \href{#method-Forest-add_numeric_split_tree}{\code{Forest$add_numeric_split_tree()}}
\item \href{#method-Forest-get_tree_leaves}{\code{Forest$get_tree_leaves()}}
\item \href{#method-Forest-get_tree_split_counts}{\code{Forest$get_tree_split_counts()}}
\item \href{#method-Forest-get_forest_split_counts}{\code{Forest$get_forest_split_counts()}}
\item \href{#method-Forest-tree_max_depth}{\code{Forest$tree_max_depth()}}
\item \href{#method-Forest-average_max_depth}{\code{Forest$average_max_depth()}}
\item \href{#method-Forest-is_empty}{\code{Forest$is_empty()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-new"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-new}{}}}
\subsection{Method \code{new()}}{
Create a new Forest object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$new(
  num_trees,
  leaf_dimension = 1,
  is_leaf_constant = FALSE,
  is_exponentiated = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_trees}}{Number of trees in the forest}

\item{\code{leaf_dimension}}{Dimensionality of the outcome model}

\item{\code{is_leaf_constant}}{Whether leaf is constant}

\item{\code{is_exponentiated}}{Whether forest predictions should be exponentiated before being returned}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Forest} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-predict"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-predict}{}}}
\subsection{Method \code{predict()}}{
Predict forest on every sample in \code{forest_dataset}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$predict(forest_dataset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{\code{ForestDataset} R class}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
vector of predictions with as many rows as in \code{forest_dataset}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-predict_raw"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-predict_raw}{}}}
\subsection{Method \code{predict_raw()}}{
Predict "raw" leaf values (without being multiplied by basis) for every sample in \code{forest_dataset}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$predict_raw(forest_dataset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_dataset}}{\code{ForestDataset} R class}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Array of predictions for each observation in \code{forest_dataset} and
each sample in the \code{ForestSamples} class with each prediction having the
dimensionality of the forests' leaf model. In the case of a constant leaf model
or univariate leaf regression, this array is a vector (length is the number of
observations). In the case of a multivariate leaf regression,
this array is a matrix (number of observations by leaf model dimension,
number of samples).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-set_root_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-set_root_leaves}{}}}
\subsection{Method \code{set_root_leaves()}}{
Set a constant predicted value for every tree in the ensemble.
Stops program if any tree is more than a root node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$set_root_leaves(leaf_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leaf_value}}{Constant leaf value(s) to be fixed for each tree in the ensemble indexed by \code{forest_num}. Can be either a single number or a vector, depending on the forest's leaf dimension.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-prepare_for_sampler"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-prepare_for_sampler}{}}}
\subsection{Method \code{prepare_for_sampler()}}{
Set a constant predicted value for every tree in the ensemble.
Stops program if any tree is more than a root node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$prepare_for_sampler(
  dataset,
  outcome,
  forest_model,
  leaf_model_int,
  leaf_value
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{\code{ForestDataset} Dataset class (covariates, basis, etc...)}

\item{\code{outcome}}{\code{Outcome} Outcome class (residual / partial residual)}

\item{\code{forest_model}}{\code{ForestModel} object storing tracking structures used in training / sampling}

\item{\code{leaf_model_int}}{Integer value encoding the leaf model type (0 = constant gaussian, 1 = univariate gaussian, 2 = multivariate gaussian, 3 = log linear variance).}

\item{\code{leaf_value}}{Constant leaf value(s) to be fixed for each tree in the ensemble indexed by \code{forest_num}. Can be either a single number or a vector, depending on the forest's leaf dimension.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-adjust_residual"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-adjust_residual}{}}}
\subsection{Method \code{adjust_residual()}}{
Adjusts residual based on the predictions of a forest

This is typically run just once at the beginning of a forest sampling algorithm.
After trees are initialized with constant root node predictions, their root predictions are subtracted out of the residual.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$adjust_residual(dataset, outcome, forest_model, requires_basis, add)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{\code{ForestDataset} object storing the covariates and bases for a given forest}

\item{\code{outcome}}{\code{Outcome} object storing the residuals to be updated based on forest predictions}

\item{\code{forest_model}}{\code{ForestModel} object storing tracking structures used in training / sampling}

\item{\code{requires_basis}}{Whether or not a forest requires a basis for prediction}

\item{\code{add}}{Whether forest predictions should be added to or subtracted from residuals}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-num_trees"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-num_trees}{}}}
\subsection{Method \code{num_trees()}}{
Return number of trees in each ensemble of a \code{Forest} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$num_trees()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Tree count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-leaf_dimension"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-leaf_dimension}{}}}
\subsection{Method \code{leaf_dimension()}}{
Return output dimension of trees in a \code{Forest} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$leaf_dimension()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Leaf node parameter size
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-is_constant_leaf"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-is_constant_leaf}{}}}
\subsection{Method \code{is_constant_leaf()}}{
Return constant leaf status of trees in a \code{Forest} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$is_constant_leaf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if leaves are constant, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-is_exponentiated"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-is_exponentiated}{}}}
\subsection{Method \code{is_exponentiated()}}{
Return exponentiation status of trees in a \code{Forest} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$is_exponentiated()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if leaf predictions must be exponentiated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-add_numeric_split_tree"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-add_numeric_split_tree}{}}}
\subsection{Method \code{add_numeric_split_tree()}}{
Add a numeric (i.e. \code{X[,i] <= c}) split to a given tree in the ensemble
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$add_numeric_split_tree(
  tree_num,
  leaf_num,
  feature_num,
  split_threshold,
  left_leaf_value,
  right_leaf_value
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tree_num}}{Index of the tree to be split}

\item{\code{leaf_num}}{Leaf to be split}

\item{\code{feature_num}}{Feature that defines the new split}

\item{\code{split_threshold}}{Value that defines the cutoff of the new split}

\item{\code{left_leaf_value}}{Value (or vector of values) to assign to the newly created left node}

\item{\code{right_leaf_value}}{Value (or vector of values) to assign to the newly created right node}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-get_tree_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-get_tree_leaves}{}}}
\subsection{Method \code{get_tree_leaves()}}{
Retrieve a vector of indices of leaf nodes for a given tree in a given forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$get_tree_leaves(tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tree_num}}{Index of the tree for which leaf indices will be retrieved}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-get_tree_split_counts"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-get_tree_split_counts}{}}}
\subsection{Method \code{get_tree_split_counts()}}{
Retrieve a vector of split counts for every training set variable in a given tree in the forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$get_tree_split_counts(tree_num, num_features)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tree_num}}{Index of the tree for which split counts will be retrieved}

\item{\code{num_features}}{Total number of features in the training set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-get_forest_split_counts"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-get_forest_split_counts}{}}}
\subsection{Method \code{get_forest_split_counts()}}{
Retrieve a vector of split counts for every training set variable in the forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$get_forest_split_counts(num_features)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_features}}{Total number of features in the training set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-tree_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-tree_max_depth}{}}}
\subsection{Method \code{tree_max_depth()}}{
Maximum depth of a specific tree in the forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$tree_max_depth(tree_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tree_num}}{Tree index within forest}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Maximum leaf depth
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-average_max_depth"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-average_max_depth}{}}}
\subsection{Method \code{average_max_depth()}}{
Average the maximum depth of each tree in the forest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$average_max_depth()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Average maximum depth
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Forest-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-Forest-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
When a forest object is created, it is "empty" in the sense that none
of its component trees have leaves with values. There are two ways to
"initialize" a Forest object. First, the \code{set_root_leaves()} method
simply initializes every tree in the forest to a single node carrying
the same (user-specified) leaf value. Second, the \code{prepare_for_sampler()}
method initializes every tree in the forest to a single node with the
same value and also propagates this information through to a ForestModel
object, which must be synchronized with a Forest during a forest
sampler loop.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Forest$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if a Forest has not yet been initialized with a constant
root value, \code{FALSE} otherwise if the forest has already been
initialized / grown.
}
}
}
