% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile.R
\name{st_tile}
\alias{st_tile}
\title{Specify parameters to load raster in blocks}
\usage{
st_tile(img_rows, img_cols, x_window, y_window, overlap = 0)
}
\arguments{
\item{img_rows}{number of input raster rows (integer)}

\item{img_cols}{number of input raster columns (integer)}

\item{x_window}{number of rows in block (integer)}

\item{y_window}{number of columns in block (integer)}

\item{overlap}{number of overlapping pixels (integer)}
}
\value{
matrix with specified \code{nXOff}, \code{nYOff}, \code{nXsize},
and \code{nYSize} parameters for every block
}
\description{
Helper function for specifying the block parameters (\code{nXOff},
\code{nYOff}, \code{nXsize}, and \code{nYSize}) required by \code{RasterIO}
argument in \link{read_stars}
}
\examples{
\dontrun{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
r = read_stars(tif, proxy = TRUE)
tiles = st_tile(nrow(r), ncol(r), 256, 256)
for (i in seq_len(nrow(tiles))) {
  tile = read_stars(tif, proxy = FALSE, RasterIO = tiles[i, ])
  # write tiles to separate files
  write_stars(tile, dsn = paste0(i, ".tif"))
}
}

}
