% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholdopt.R
\name{optimal_threshold}
\alias{optimal_threshold}
\title{Optimize threshold for clean data extraction.}
\usage{
optimal_threshold(
  refdata,
  outliers,
  var_col = NULL,
  warn = FALSE,
  verbose = FALSE,
  plotsetting = list(plot = FALSE, group = NULL),
  cutoff = 0.6
)
}
\arguments{
\item{refdata}{\code{dataframe}. Species data frame from precleaned analysis.}

\item{outliers}{\code{datacleaner}. Datacleaner output with outliers flagged in \code{multidetect} function.}

\item{var_col}{\code{string}. A column with species names if \code{dataset} for species is a dataframe not a list.
See \code{\link{pred_extract}} for extracting environmental data.}

\item{warn}{\code{logical}. If \strong{TRUE}, warning on whether absolute
outliers obtained at a low threshold is indicated. Default \strong{TRUE}.}

\item{verbose}{\code{logical}. If true, then messages about the outlier flagging will be displayed.}

\item{plotsetting}{\code{list}. to show plot of loess fitted function with local and global maxima (optimal threshold and clean data).
The list had two parameters. 1) plot to indicate the plot and group to provide the plot title.}

\item{cutoff}{\code{numeric}. Ranging from 0.5 to 0.8 indicating the cutoff to initiate the
LOESS model to optimize the identification of absolute outliers.}
}
\value{
Either a \code{list} or \code{dataframe} of cleaned records for multiple species.
}
\description{
Optimize threshold for clean data extraction.
}
