% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.gaussian.smooth.R
\name{raster.gaussian.smooth}
\alias{raster.gaussian.smooth}
\title{Gaussian smoothing of raster}
\usage{
raster.gaussian.smooth(
  x,
  s = 2,
  n = 5,
  scale = FALSE,
  type = c("mean", "median", "sd", "convolution"),
  ...
)
}
\arguments{
\item{x}{A terra SpatRaster raster object}

\item{s}{Standard deviation (sigma) of kernel (default is 2)}

\item{n}{Size of the focal matrix, single value (default is 
5 for 5x5 window)}

\item{scale}{(FALSE/TRUE) Scale sigma to the resolution of the raster}

\item{type}{The statistic to use in the smoothing operator; 
"mean", "median", "sd", "convolution"}

\item{...}{Additional arguments passed to terra::focal}
}
\value{
A terra SpatRaster class object of the local distributional moment
}
\description{
Applies a Gaussian smoothing kernel to smooth raster.
}
\details{
This applies a Gaussian Kernel smoother. The convolution option performs
a Gaussian decomposition whereas the other options use the kernel
as weights for the given statistic.
}
\examples{
library(terra)
elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))

# Calculate Gaussian smoothing with sigma = 2 and 7x7 window
g1 <- raster.gaussian.smooth(elev, s=2, n=7)
    plot(c(elev,g1))

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
