% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_results.R
\name{summarise_results}
\alias{summarise_results}
\title{Summarise bias and dispersion (MADm) across simulated fits}
\usage{
summarise_results(results)
}
\arguments{
\item{results}{Output from \code{run_model()}.}
}
\value{
Data frame with only parameters that were estimated in the Stan model.
}
\description{
Summarise bias and dispersion (MADm) across simulated fits
}
\examples{
\donttest{
if (requireNamespace("cmdstanr", quietly = TRUE) ||
    requireNamespace("rstan", quietly = TRUE)) {
  sim <- simulate_data(ind = 100, Valpha = 0.2, Vepsilon = 0.1, iterations = 2)
  res <- run_model(sim, model = "Trait.stan", iter = 500, cores = 2)
  summary(res)
} else {
  message("CmdStanR or rstan not available; example skipped.")
}
}
}
