% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{shinySbmApp}
\alias{shinySbmApp}
\title{Run the Shiny Application}
\usage{
shinySbmApp(
  nbCore_control = TRUE,
  console_verbosity = TRUE,
  onStart = NULL,
  options = list(launch.browser = TRUE),
  enableBookmarking = NULL,
  uiPattern = "/",
  ...
)
}
\arguments{
\item{nbCore_control}{Allow to control the number of Cores when running an `sbm`}

\item{console_verbosity}{boolean boolean should the console be printing 'sbm' outputs}

\item{onStart}{A function that will be called before the app is actually run.
This is only needed for \code{shinyAppObj}, since in the \code{shinyAppDir}
case, a \code{global.R} file can be used for this purpose.}

\item{options}{Named options that should be passed to the \code{runApp} call
(these can be any of the following: "port", "launch.browser", "host", "quiet",
"display.mode" and "test.mode"). You can also specify \code{width} and
\code{height} parameters which provide a hint to the embedding environment
about the ideal height/width for the app.}

\item{enableBookmarking}{Can be one of \code{"url"}, \code{"server"}, or
\code{"disable"}. The default value, \code{NULL}, will respect the setting from
any previous calls to  \code{\link[shiny:enableBookmarking]{enableBookmarking()}}. See \code{\link[shiny:enableBookmarking]{enableBookmarking()}}
for more information on bookmarking your app.}

\item{uiPattern}{A regular expression that will be applied to each \code{GET}
request to determine whether the \code{ui} should be used to handle the
request. Note that the entire request path must match the regular
expression in order for the match to be considered successful.}

\item{...}{arguments to pass to golem_opts.
See `?golem::get_golem_options` for more details.}
}
\value{
No return value, called to launch the 'shiny' application
}
\description{
Run the Shiny Application
}
