% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeR.R
\name{write.image.with.outline}
\alias{write.image.with.outline}
\title{Write outlines on top of the original images for quality checking}
\usage{
write.image.with.outline(object, folder = NA, fname = NA, doProgress = TRUE)
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{folder}{The folder name where the image is stored}

\item{fname}{Image file name. Not including the extension ".jpg"}

\item{doProgress}{If TRUE, a progressbar is shown}
}
\value{
None
}
\description{
A function which writes the outlines which were extracted from the images in the folder "Fixed" on top of the corresponding images in the "Original" folder. Viewing the resulted images in the folder "Original_with_outlines" is a good quality check to ensure the correct outline has been extracted. If the outline is not correct, then the image can be fixed in an image software, such as GIMP (www.gimp.org), placed in the "Fixed" folder and then the \code{detect.outline} step is repeated.
The function \code{\link{detect.outline}} calls this function if the parameter \code{write.outline.w.org} is set to \code{TRUE}.
}
\examples{
\dontrun{
#Use test data from Libungan and Palsson (2015) and run the following lines:
shape = shapeR("ShapeAnalysis/","FISH.csv")
shape = detect.outline(shape,write.outline.w.org = FALSE)
write.image.with.outline(shape)}
}
\references{
Libungan LA and Palsson S (2015) ShapeR: An R Package to Study Otolith Shape Variation among Fish Populations. PLoS ONE 10(3): e0121102. \url{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0121102}
}
\author{
Lisa Anne Libungan
}
