% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia_setup.R
\name{install_julia_env}
\alias{install_julia_env}
\title{Install, update, or remove Julia environment}
\usage{
install_julia_env(remove = FALSE)
}
\arguments{
\item{remove}{If TRUE, remove Julia environment for sdbuildR. This will delete the Manifest.toml file, as well as the SystemDynamicsBuildR.jl package. All other Julia packages remain untouched.}
}
\value{
Invisibly returns NULL after instantiating the Julia environment.
}
\description{
Instantiate the Julia environment for sdbuildR to run stock-and-flow models using Julia. For more guidance, please see \href{https://kcevers.github.io/sdbuildR/articles/julia-setup.html}{this vignette}.
}
\details{
\code{install_julia_env()} will:
\itemize{
\item Start a Julia session
\item Activate a Julia environment using sdbuildR's Project.toml
\item Install SystemDynamicsBuildR.jl from GitHub (https://github.com/KCEvers/SystemDynamicsBuildR.jl)
\item Install all other required Julia packages
\item Create Manifest.toml
\item Precompile packages for faster subsequent loading
\item Stop the Julia session
}

Note that this may take 10-25 minutes the first time as Julia downloads and compiles packages.
}
\examples{
\dontshow{if (julia_status()$julia_found && Sys.getenv("NOT_CRAN") == "true") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  install_julia_env()

  # Remove Julia environment
  install_julia_env(remove = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=use_julia]{use_julia()}}, \code{\link[=julia_status]{julia_status()}}
}
\concept{julia}
