% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.poisson_rt}
\alias{plot.poisson_rt}
\title{Plot estimated Rt values from a \code{poisson_rt} object}
\usage{
\method{plot}{poisson_rt}(x, lambda = NULL, ...)
}
\arguments{
\item{x}{output of the function \code{\link[=estimate_rt]{estimate_rt()}} of class \code{poisson_rt}}

\item{lambda}{select which Rt's to plot. If not provided,
all Rt's are plotted.}

\item{...}{Not used.}
}
\value{
a \link[ggplot2:ggplot]{ggplot2::ggplot}
}
\description{
Produces a figure showing some or all estimated Rt values for different
values of the penalty. The result is a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}. Additional user
modifications can be added as desired.
}
\examples{
y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
out <- estimate_rt(y, lambda = log(c(1.1, 1.3, 1.5)))
plot(out)
}
