% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subdirRule.R
\name{subdirRule}
\alias{subdirRule}
\title{Rule for running the make process on a subdirectory}
\usage{
subdirRule(target, depends = NULL, task = "all", targetTask = "all")
}
\arguments{
\item{target}{Name of the subdirectory}

\item{depends}{Must be \code{NULL}}

\item{task}{A character vector of parent task names. The mechanism of tasks allows to group
rules. Anything different from \code{'all'} will cause creation of a new task depending on the given
rule. Executing \verb{make taskname} will then force building of this rule.}

\item{targetTask}{What task to execute in the subdirectory.}
}
\value{
An instance of S2 classs \code{rmake.rule}
}
\description{
The subdirectory in the \code{target} argument is assumed to contain its own \code{Makefile}. This rule
causes the execution of \verb{make <targetTask>} in this subdirectory (where \verb{<targetTask>} is the
value of the \code{targetTask} argument).
}
\seealso{
\code{\link[=rule]{rule()}}, \code{\link[=makefile]{makefile()}}
}
\author{
Michal Burda
}
