% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airm.R
\name{airm_vec}
\alias{airm_vec}
\title{Compute the AIRM Vectorization of Tangent Space}
\usage{
airm_vec(sigma, v)
}
\arguments{
\item{sigma}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the reference point.}

\item{v}{A symmetric matrix of class \code{dspMatrix}, representing a tangent vector.}
}
\value{
A numeric vector, representing the vectorized tangent image.
}
\description{
Vectorizes a tangent matrix into a vector in Euclidean space using AIRM.
}
\examples{
if (requireNamespace("Matrix", quietly = TRUE)) {
  library(Matrix)
  sigma <- diag(2) |>
    Matrix::nearPD() |>
    _$mat |>
    Matrix::pack()
  v <- diag(c(1, 0.5)) |>
    Matrix::symmpart() |>
    Matrix::pack()
  airm_vec(sigma, v)
}
}
