% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_fit_mreg_mediator_modeling.R
\name{fit_mreg}
\alias{fit_mreg}
\title{Fit a model for the mediator given the treatment and covariates.}
\usage{
fit_mreg(mreg, data, avar, mvar, cvar, emm_ac_mreg = NULL)
}
\arguments{
\item{mreg}{A character vector of length 1. Mediator regression type: \code{"linear"} or \code{"logistic"}.}

\item{data}{Data frame containing the following relevant variables.}

\item{avar}{A character vector of length 1. Treatment variable name.}

\item{mvar}{A character vector of length 1. Mediator variable name.}

\item{cvar}{A character vector of length > 0. Covariate names. Use \code{NULL} if there is no covariate. However, this is a highly suspicious situation. Even if \code{avar} is randomized, \code{mvar} is not. Thus, there are usually some confounder(s) to account for the common cause structure (confounding) between \code{mvar} and \code{yvar}.}

\item{emm_ac_mreg}{A character vector of length > 0. Effect modifiers names. The covariate vector in treatment-covariate product term in the mediator model.}
}
\value{
A regression object of class lm (linear) or glm (logistic)
}
\description{
\code{\link{lm}} is called if \code{mreg = "linear"}. \code{\link{glm}} is called with \code{family = binomial()} if \code{mreg = "logistic"}.
}
