% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs_deriv.R
\name{bs_deriv}
\alias{bs_deriv}
\title{Nth derivative of spline basis}
\usage{
bs_deriv(
  x,
  knots,
  degree = 3L,
  Boundary.knots = range(x),
  derivative = 1,
  intercept = TRUE
)
}
\arguments{
\item{x}{a numeric vector of values at which to evaluate the B-spline functions or derivatives.}

\item{knots}{the internal breakpoints that define the spline.}

\item{degree}{degree of the piecewise polynomial—default is 3 for cubic splines.}

\item{Boundary.knots}{boundary points at which to anchor the B-spline basis. 
Set to [0,1] if you want this to be your domain.}

\item{derivative}{a positive integer value that specifies which derivative to take. Defaults to 1 for 1st derivative.
Value of 0 returns the original set of b-spline basis functions.}

\item{intercept}{if TRUE, an intercept is included in the basis; default is TRUE}
}
\value{
A matrix containing:
\item{basis}{A B-spline basis that can be used to approximate the derivative of a function.}
}
\description{
This function gets derivative of a spline basis. Adapted from \code{bs()} function in \code{splines} package.
}
\author{
Julia Wrobel \email{julia.wrobel@cuanschutz.edu}
}
