% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportLogging.R
\name{exportLogging}
\alias{exportLogging}
\alias{exportLogging.redcapApiConnection}
\title{Export Logging Records}
\usage{
exportLogging(
  rcon,
  logtype = character(0),
  user = character(0),
  record = character(0),
  dag = character(0),
  beginTime = as.POSIXct(character(0)),
  endTime = as.POSIXct(character(0)),
  batchInterval = NULL,
  ...
)

\method{exportLogging}{redcapApiConnection}(
  rcon,
  logtype = character(0),
  user = character(0),
  record = character(0),
  dag = character(0),
  beginTime = as.POSIXct(character(0)),
  endTime = as.POSIXct(character(0)),
  batchInterval = NULL,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{logtype}{\code{character(0/1)}. The log event types to export.
When the length is zero, all event types are exported. Otherwise, it
must be one of
\code{c("export", "manage", "user", "record", "record_add", "record_edit", "record_delete", "lock_record", "page_view")}}

\item{user}{\code{character(0/1)}. Users for whom to return logs. By default
logs for all users are returned.}

\item{record}{\code{character(0/1)}. Record ID for which logs are to be returned.
By default, logs are returned for all records.}

\item{dag}{\code{character(0/1)}. Data access group ID for which to return logs.
By default, logs are returned for all data access groups.}

\item{beginTime}{\code{POSIXct(0/1)}. When given, only
logs recorded on or after this time will be returned. The time specified
is rounded to minutes and ignores the timezone. This can cause issues
if the caller and server computers are configured in different timezones.
Least surprising behavior is making sure the date specified is encoded
in the timezone of the REDCap server.}

\item{endTime}{\code{POSIXct(0/1)}. When given, only logs
recorded on or before this time will be returned. If using batchInterval
it will only be before this time. See \code{beginTime} for details on time
encoding.}

\item{batchInterval}{\code{integerish(1)}. When provided will
batch log pulls to intervals of this many days. Requires
that beginTime is specified.}

\item{...}{Arguments to pass to other methods}
}
\value{
Returns a data frame with columns\tabular{ll}{
    \tab  \cr
   \code{timestamp} \tab The date/time of the logging record. \cr
   \code{username} \tab The user name of the user that performed the action being logged. \cr
   \code{action} \tab The classification of action being logged. \cr
   \code{details} \tab Details of the action being logged. \cr
   \code{record} \tab The record ID associated with the action being logged. When not related to a record, this will be \code{NA} \cr
}
}
\description{
These methods enable to user to export the logging
(audit trail) of all changes made to a project, including data exports,
data changes, project metadata changes, modification of user rights, etc.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
                    
# Export all of the logging events       
exportLogging(rcon)
  
# Export all of the events for record '2'
exportLogging(rcon, 
              record = "2")
                
# Export all of the events where a record was deleted
exportLoging(rcon, 
             logtype = "record_delete")
}
}
