% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{as_network}
\alias{as_network}
\title{Create a network from a collection of line strings}
\usage{
as_network(edges, flatten = TRUE, clean = TRUE)
}
\arguments{
\item{edges}{An \code{\link[sf:sf]{sf::sf}} or \code{\link[sf:sfc]{sf::sfc_LINESTRING}} object with the
network edges}

\item{flatten}{Whether all intersections between edges should be
converted to nodes}

\item{clean}{Whether general cleaning tasks should be run on the generated
network (see \code{\link[=clean_network]{clean_network()}} for the description of tasks)}
}
\value{
An \code{\link[sfnetworks:sfnetwork]{sfnetworks::sfnetwork}} object
}
\description{
Create a network from a collection of line strings
}
\examples{
edges <- sf::st_sfc(
  sf::st_linestring(matrix(c(0, 0, 1, 1), ncol = 2, byrow = TRUE)),
  sf::st_linestring(matrix(c(0, 1, 1, 0), ncol = 2, byrow = TRUE)),
  crs = sf::st_crs("EPSG:32635")
)

# Run with default values
as_network(edges)

# Only build the spatial network
as_network(edges, flatten = FALSE, clean = FALSE)
}
