% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainette_explor.R
\name{rainette_explor}
\alias{rainette_explor}
\title{Shiny gadget for rainette clustering exploration}
\usage{
rainette_explor(res, dtm = NULL, corpus_src = NULL)
}
\arguments{
\item{res}{result object of a \code{rainette} clustering}

\item{dtm}{the dfm object used to compute the clustering}

\item{corpus_src}{the quanteda corpus object used to compute the dtm}
}
\value{
No return value, called for side effects.
}
\description{
Shiny gadget for rainette clustering exploration
}
\examples{
\dontrun{
require(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
tok <- tokens(corpus, remove_punct = TRUE)
tok <- tokens_remove(tok, stopwords("en"))
dtm <- dfm(tok, tolower = TRUE)
dtm <- dfm_trim(dtm, min_docfreq = 3)
res <- rainette(dtm, k = 3, min_segment_size = 15)
rainette_explor(res, dtm, corpus)
}

}
\seealso{
\code{rainette_plot}
}
