% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/containerResizer.R
\name{splitCard2}
\alias{splitCard2}
\title{Re sizable split screen container version 2}
\usage{
splitCard2(
  left,
  right,
  bg.left.color = NULL,
  bg.right.color = NULL,
  border.color = NULL,
  text.left.color = "black",
  text.right.color = "black",
  slider.position = charNum1to100
)
}
\arguments{
\item{left}{content on the left or top}

\item{right}{content on the right or bottom}

\item{bg.left.color}{left panel color e.g red, black or #333333}

\item{bg.right.color}{right panel color e.g red, black or #333333}

\item{border.color}{border color of the container e.g. red or #f5f5f5}

\item{text.left.color}{color of left panel text}

\item{text.right.color}{color of right panel text}

\item{slider.position}{position of the slider in percent}
}
\value{
Realizable split screen container style 2
}
\description{
Highly customizable and re sizable split screen container version 2
}
\section{Examples for r2resize}{

More examples and demo pages are located at this link -
\url{https://rpkg.net/package/r2resize}.
}

\examples{
#Use the default split card 2 function
#add a question on one side, and answer on the other
r2resize::splitCard2(
  shiny::tags$h1("Question 1"),
  shiny::tags$h1("Answer 1"),
  slider.position = "40"
)

#specify the backgroun color for the sides
r2resize::splitCard2(
  "Sample r2symbols 1",
  "Sample nextGen 1",
  bg.right.color = "white",
  bg.left.color = "lightgray"
)


#alter the border color
#specify the text color for each side
r2resize::splitCard2(
  "Sample shinyStorePlus",
  "Sample nextGen 1",
  bg.right.color = "white",
  bg.left.color = "lightgray",
  border.color = "black",
  text.left.color = "black",
  text.right.color = "black"
)

##change the text color from one side to the other
r2resize::splitCard2(
  "Sample sciRmdTheme 1",
  "Sample nextGen 1",
  bg.right.color = "white",
  bg.left.color = "lightgray",
  border.color = "gray",
  text.left.color = "red",
  text.right.color = "blue"
)

}
