% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.InteractionClassification.R,
%   R/summary.payoffs.R
\name{summary}
\alias{summary}
\title{Summarize an InteractionClassification object}
\usage{
summary(object, ...)

summary(object, ...)
}
\arguments{
\item{object}{A payoffs object.}

\item{...}{Additional arguments (not used).}
}
\value{
A \code{data.frame} with one row per interaction cluster and the following columns:
\describe{
\item{classification}{Cluster label (as factor).}
\item{cds_diff_mean}{Mean of CD4 differences in the group.}
\item{vlogs_diff_mean}{Mean of viral load differences in the group.}
\item{n}{Number of observations in the group.}
}
}
\description{
Computes summary statistics by classification group from an object of class
\code{InteractionClassification}, including mean differences in viral load and CD4 counts,
and the number of observations per cluster.

This function summarizes the payoffs object by classification.
}
\examples{
set.seed(42)
data(cd_3)
cd_data <- cd_3[,-1]
cd_result <- cds_diff(cd_data)
data(vl_3)
vl_data <- vl_3[,-1]
vl_result <- vlogs_diff(vl_data)
result <- InteractionClassification(cd_result = cd_result, vl_result = vl_result)
summary(result)
set.seed(42)
data(cd_3)
cd_data <- cd_3[,-1]
cd_result <- cds_diff(cd_data)
data(vl_3)
vl_data <- vl_3[,-1]
vl_result <- vlogs_diff(vl_data)
result <- InteractionClassification(cd_result = cd_result, vl_result = vl_result)
data(preds)
payoffs_results <- estimate_payoffs(result, preds)
summary(payoffs_results)
}
