% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sint.R
\name{plot_sint}
\alias{plot_sint}
\title{QTLs with respective support interval plots}
\usage{
plot_sint(data, model, pheno.col = NULL, main = NULL, drop = FALSE)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{model}{an object of class \code{qtlpoly.profile} or \code{qtlpoly.remim}.}

\item{pheno.col}{a numeric vector with the phenotype column numbers to be plotted; if \code{NULL}, all phenotypes from \code{'data'} will be included.}

\item{main}{a character string with the main title; if \code{NULL}, no title will be shown.}

\item{drop}{if \code{TRUE}, phenotypes with no QTL will be dropped; if \code{FALSE} (default), all phenotypes will be shown.}
}
\value{
A \pkg{ggplot2} with QTL bars for each linkage group.
}
\description{
Creates a plot where colored bars represent the support intervals for QTL peaks (black dots).
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)

  # Plot support intervals
  plot_sint(data = data, model = remim.mod)
  }
}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{read_data}}, \code{\link[qtlpoly]{remim}}, \code{\link[qtlpoly]{profile_qtl}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
