% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstab.R
\name{crosstab}
\alias{crosstab}
\title{Two-way frequency table}
\usage{
crosstab(
  data,
  rowvar,
  colvar,
  type = c("freq", "percent", "rowpercent", "colpercent"),
  total = TRUE,
  na.rm = TRUE,
  digits = 2,
  chisquare = FALSE,
  plot = FALSE
)
}
\arguments{
\item{data}{data frame}

\item{rowvar}{row factor (unquoted)}

\item{colvar}{column factor (unquoted)}

\item{type}{statistics to print. Options are \code{"freq"},
\code{"percent"}, \code{"rowpercent"}, or \code{"colpercent"}
for frequencies, cell percents, row percents, or column percents).}

\item{total}{logical. if TRUE, includes total percents.}

\item{na.rm}{logical. if TRUE, deletes cases with missing values.}

\item{digits}{number of decimal digits to report for percents.}

\item{chisquare}{logical. If \code{TRUE} perform a chi-square test
of independence}

\item{plot}{logical. If \code{TRUE} generate stacked bar chart.}
}
\value{
If \code{plot=TRUE}, return a ggplot2 graph.
Otherwise the function return a list with 6 components:
\itemize{
\item{\code{table}}{ (table). Table of frequencies or percents}
\item{\code{type}}{ (character). Type of table to print}
\item{\code{total}}{ (logical). If \code{TRUE}, print row and or column totals}
\item{\code{digits}}{ (numeric). number of digits to print}
\item{\code{rowname}}{ (character). Row variable name}
\item{\code{colname}}{ (character). Column variable name}
\item{\code{chisquare}}{ (character). If \code{chisquare=TRUE}, contains
the results of the Chi-square test. \code{NULL} otherwise.}
}
}
\description{
This function creates a two way frequency table.
}
\details{
Given a data frame, a row factor, a column factor, and a
type (frequencies, cell percents, row percents, or column percents)
the function provides the requested cross-tabulation.

If \code{na.rm = FALSE}, a level labeled \code{<NA>} added. If
\code{total = TRUE}, a level labeled \code{Total} is added. If
\code{chisquare = TRUE}, a chi-square test of independence is
performed.
}
\examples{
# print frequencies
crosstab(mtcars, cyl, gear)

# print cell percents
crosstab(cardata, vehicle_size, driven_wheels)
crosstab(cardata, vehicle_size, driven_wheels,
plot=TRUE)
crosstab(cardata, driven_wheels, vehicle_size,
type="colpercent", plot=TRUE, chisquare=TRUE)
}
\seealso{
\link{print.crosstab}, \link{plot.crosstab}
}
