% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluck.R
\name{chuck}
\alias{chuck}
\title{Get an element deep within a nested data structure, failing if it doesn't
exist}
\usage{
chuck(.x, ...)
}
\arguments{
\item{.x}{A vector or environment}

\item{...}{A list of accessors for indexing into the object. Can be
an positive integer, a negative integer (to index from the right),
a string (to index into names), or an accessor function
(except for the assignment variants which only support names and
positions). If the object being indexed is an S4 object,
accessing it by name will return the corresponding slot.

\link[rlang:dyn-dots]{Dynamic dots} are supported. In particular, if
your accessors are stored in a list, you can splice that in with
\verb{!!!}.}
}
\description{
\code{chuck()} implements a generalised form of \code{[[} that allow you to index
deeply and flexibly into data structures. If the index you are trying to
access does not exist (or is \code{NULL}), it will throw (i.e. chuck) an error.
}
\examples{
x <- list(a = 1, b = 2)

# When indexing an element that doesn't exist `[[` sometimes returns NULL:
x[["y"]]
# and sometimes errors:
try(x[[3]])

# chuck() consistently errors:
try(chuck(x, "y"))
try(chuck(x, 3))
}
\seealso{
\code{\link[=pluck]{pluck()}} for a quiet equivalent.
}
