% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Hodgkin}
\alias{Hodgkin}
\title{T-cell counts from Hodgkin's disease patients.}
\format{
A labelled tibble with 40 rows and 3 variables:
\describe{
\item{CD4}{Concentration of CD4+ T-cells (cells / mm^3).}
\item{CD8}{Concentration of CD8+ T-cells (cells / mm^3).}
\item{Group}{Group, factor with levels "Non-Hodgkin" and "Hodgkin".}
}
}
\source{
Shapiro, CM, et al (1986) Immunologic status of patients in remission from Hodgkin's disease and
disseminated malignancies. Am J Med Sci 293:366-370.

Altman, DA (1991) Practical statistics for medical research. Chapman & Hall/CRC.
}
\usage{
Hodgkin
}
\description{
Number of CD4+ T-cells and CD8+ T-cells in blood samples from patients in remission from Hodgkin's disease or
in remission from disseminated malignancies.
}
\examples{
data(Hodgkin)
require(dplyr, quietly = TRUE)
require(sjlabelled, quietly = TRUE)

Hodgkin <- Hodgkin |>
  mutate(
    Ratio = CD4 / CD8
  ) |>
  var_labels(
    Ratio = "CD4+ / CD8+ T-cells"
  )

estat(~ Ratio | Group, data = Hodgkin)

Hodgkin |>
  qq_plot(~ Ratio | Group)

Hodgkin$Ratio <- Hodgkin$CD4 / Hodgkin$CD8
estat(~ Ratio | Group, data = Hodgkin)

qq_plot(~ Ratio | Group, data = Hodgkin)
}
\keyword{datasets}
