% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_eval_functions.R
\name{get_policy_actions}
\alias{get_policy_actions}
\title{Get Policy Actions}
\usage{
get_policy_actions(object)
}
\arguments{
\item{object}{Object of class \link{policy_eval}.}
}
\value{
\link[data.table:data.table]{data.table::data.table} with keys \code{id} and \code{stage} and action variable
\code{d}.
}
\description{
\code{get_policy_actions()} extract the actions dictated by the
(learned and possibly cross-fitted) policy a every stage.
}
\examples{
### Two stages:
d <- sim_two_stage(5e2, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# defining a policy learner based on cross-fitted doubly robust Q-learning:
pl <- policy_learn(type = "drql",
                   control = control_drql(qv_models = list(q_glm(~C_1), q_glm(~C_1+C_2))),
                   full_history = TRUE,
                   L = 2) # number of folds for cross-fitting

# evaluating the policy learner using 2-fold cross fitting:
pe <- policy_eval(type = "dr",
                   policy_data = pd,
                   policy_learn = pl,
                   q_models = q_glm(),
                   g_models = g_glm(),
                   M = 2) # number of folds for cross-fitting

# Getting the cross-fitted actions dictated by the fitted policy:
head(get_policy_actions(pe))
}
