% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_multiagent.R
\name{create_multiagent}
\alias{create_multiagent}
\title{Create a \strong{pointblank} \emph{multiagent} object}
\usage{
create_multiagent(..., lang = NULL, locale = NULL)
}
\arguments{
\item{...}{\emph{Pointblank agents}

\verb{<series of obj:<ptblank_agent>>} // \strong{required}

One or more \strong{pointblank} agent objects.}

\item{lang}{\emph{Reporting language}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The language to use for any reporting that will be generated from the
\emph{multiagent}. (e.g., individual \emph{agent reports}, \emph{multiagent reports},
etc.). By default, \code{NULL} will create English (\code{"en"}) text. Other options
include French (\code{"fr"}), German (\code{"de"}), Italian (\code{"it"}), Spanish
(\code{"es"}), Portuguese (\code{"pt"}), Turkish (\code{"tr"}), Chinese (\code{"zh"}), Russian
(\code{"ru"}), Polish (\code{"pl"}), Danish (\code{"da"}), Swedish (\code{"sv"}), and Dutch
(\code{"nl"}).}

\item{locale}{\emph{Locale for value formatting within reports}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale ID to use for formatting values in the reporting outputs
according the locale's rules. Examples include \code{"en_US"} for English
(United States) and \code{"fr_FR"} for French (France); more simply, this can be
a language identifier without a country designation, like "es" for Spanish
(Spain, same as \code{"es_ES"}).}
}
\value{
A \code{ptblank_multiagent} object.
}
\description{
Multiple \emph{agents} can be part of a single object called the \emph{multiagent}.
This can be useful when gathering multiple agents that have performed
interrogations in the past (perhaps saved to disk with \code{\link[=x_write_disk]{x_write_disk()}}).
When be part of a \emph{multiagent}, we can get a report that shows how data
quality evolved over time. This can be of interest when it's important to
monitor data quality and even the evolution of the validation plan itself.
The reporting table, generated by printing a \code{ptblank_multiagent} object or
by using the \code{\link[=get_multiagent_report]{get_multiagent_report()}} function, is, by default, organized by
the interrogation time and it automatically recognizes which validation steps
are equivalent across interrogations.
}
\section{Examples}{


For the example below, we'll use two different, yet simple tables.

First, \code{tbl_1}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_1 <-
  dplyr::tibble(
    a = c(5, 5, 5, 5, 5, 5),
    b = c(1, 1, 1, 2, 2, 2),
    c = c(1, 1, 1, 2, 3, 4),
    d = LETTERS[a],
    e = LETTERS[b],
    f = LETTERS[c]
  )
  
tbl_1
#> # A tibble: 6 x 6
#>       a     b     c d     e     f    
#>   <dbl> <dbl> <dbl> <chr> <chr> <chr>
#> 1     5     1     1 E     A     A    
#> 2     5     1     1 E     A     A    
#> 3     5     1     1 E     A     A    
#> 4     5     2     2 E     B     B    
#> 5     5     2     3 E     B     C    
#> 6     5     2     4 E     B     D
}\if{html}{\out{</div>}}

And next, \code{tbl_2}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_2 <-
  dplyr::tibble(
    a = c(5, 7, 6, 5, 8, 7),
    b = LETTERS[1:6]
  )

tbl_2
#> # A tibble: 6 x 2
#>       a b    
#>   <dbl> <chr>
#> 1     5 A    
#> 2     7 B    
#> 3     6 C    
#> 4     5 D    
#> 5     8 E    
#> 6     7 F
}\if{html}{\out{</div>}}

Next, we'll create two different agents, each interrogating a different
table.

First up, is \code{agent_1}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent_1 <-
  create_agent(
    tbl = tbl_1,
    tbl_name = "tbl_1",
    label = "Example table 1."
  ) \%>\%
  col_vals_gt(columns = a, value = 4) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Then, \code{agent_2}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent_2 <-
  create_agent(
    tbl = tbl_2,
    tbl_name = "tbl_2",
    label = "Example table 2."
  ) \%>\%
  col_is_character(columns = b) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Now, we'll combine the two agents into a \emph{multiagent} with the
\code{create_multiagent()} function. Printing the \code{"ptblank_multiagent"} object
displays the multiagent report with its default options (i.e., a 'long'
report view).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{multiagent <- create_multiagent(agent_1, agent_2)
  
multiagent
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_create_multiagent_1.png" alt="This image was generated from the first code example in the `create_multiagent()` help file." style="width:100\%;">
}
}

To take advantage of more display options, we could use the
\code{\link[=get_multiagent_report]{get_multiagent_report()}} function. The added functionality there allows for
a 'wide' view of the data (useful for monitoring validations of the same
table over repeated interrogations), the ability to modify the title of the
multiagent report, and a means to export the report to HTML (via
\code{\link[=export_report]{export_report()}}).
}

\section{Function ID}{

10-1
}

\seealso{
Other The multiagent: 
\code{\link{get_multiagent_report}()},
\code{\link{read_disk_multiagent}()}
}
\concept{The multiagent}
