% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{getRatioCoords}
\alias{getRatioCoords}
\title{Move a vector n elements forward or backward.}
\usage{
getRatioCoords(
  ratio,
  width = NULL,
  height = NULL,
  input = c("coords", "prop"),
  ...
)
}
\arguments{
\item{ratio}{Numeric, height : width ratio. If \code{ratio} > 1, the width is 
larger than the height, if \code{ration} < 1, the height is 
larger than the width.}

\item{width}{The desired width in plot coordinates or proportions. 
If not specified (NULL), 
the maximal width fitting in the plot region is returned.}

\item{height}{The desired height in plot coordinates or proportions. 
If not specified (NULL), 
the maximal height fitting in the plot region is returned.}

\item{input}{Unit of input width and height, 'coords' (plot coordinates, default),
or 'prop' (proportions of plot region).}

\item{...}{Optional arguments: \code{xcenter}, \code{xleft}, or 
\code{xright}, and \code{ycenter}, \code{ybottom}, or 
\code{ytop} could be specified. If not specified, the width and height are 
centered around the center of the plot.}
}
\value{
A list with 5 elements:
\itemize{
\item \code{width}: width of the element in x-axis coordinates;
\item \code{height}: height of the element in y-axis coordinates;
\item \code{ratio}: provided ratio (for confirmation);
\item \code{x}: two-number vector with x-coordinates of 
left and right sides;
\item \code{y}: two-number vector with y-coordinates of 
bottom and top sides.
}
}
\description{
Move a vector n elements forward or backward.
}
\examples{
data(img)
emptyPlot(100, c(50, 100), h0=0, v0=0)
# calculate height : width ratio of image:
im.r <- dim(img$image)[1]/dim(img$image)[2]
p <- getRatioCoords(ratio=im.r, width=20)
# inspect p:
p
# No position specified, so centered:
plot_image(img, type='image', add=TRUE,
    xrange=p$x, yrange=p$y)
# ... or we could provide a position:
p <- getRatioCoords(ratio=im.r, width=20,
    xleft=20, ybottom=60)
plot_image(img, type='image', add=TRUE,
    xrange=p$x, yrange=p$y)

# Using proportions of plot region:
p <- getRatioCoords(ratio=im.r, height=.5,
    xleft=0, ytop=1, input='prop')
plot_image(img, type='image', add=TRUE,
    xrange=p$x, yrange=p$y)

# Changing the ratio to square:
p <- getRatioCoords(ratio=1, height=.5,
    xright=1, ybottom=0, input='prop')
plot_image(img, type='image', add=TRUE,
    xrange=p$x, yrange=p$y)
# ... and to a long rectangle:
p <- getRatioCoords(ratio=.5, height=1,
    xright=1, ybottom=0, input='prop')
plot_image(img, type='image', add=TRUE,
    xrange=p$x, yrange=p$y, 
    replace.colors=list('#B.+'='#FF000033'),
    border='red')

}
\seealso{
Other Utility functions: 
\code{\link{findAbsMin}()},
\code{\link{find_n_neighbors}()},
\code{\link{firstLetterCap}()},
\code{\link{getArrowPos}()},
\code{\link{getDec}()},
\code{\link{getRange}()},
\code{\link{get_palette}()},
\code{\link{group_sort}()},
\code{\link{inch2coords}()},
\code{\link{isColor}()},
\code{\link{list2str}()},
\code{\link{move_n_point}()},
\code{\link{orderBoxplot}()},
\code{\link{se}()},
\code{\link{sortGroups}()}
}
\author{
Jacolien van Rij
}
\concept{Utility functions}
