% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc.R
\docType{data}
\name{pc}
\alias{pc}
\title{Pharmacokinetic Concentrations}
\format{
A data frame with 20 columns:
\describe{
\item{STUDYID}{Study Identifier}
\item{DOMAIN}{Domain Abbreviation}
\item{USUBJID}{Unique Subject Identifier}
\item{PCSEQ}{Sequence Number}
\item{PCTESTCD}{Pharmacokinetic Test Short Name}
\item{PCTEST}{Pharmacokinetic Test Name}
\item{PCORRES}{Result or Finding in Original Units}
\item{PCORRESU}{Original Units}
\item{PCSTRESC}{Character Result/Finding in Std Format}
\item{PCSTRESN}{Numeric Result/Finding in Standard Units}
\item{PCSTRESU}{Standard Units}
\item{PCNAM}{Vendor Name}
\item{PCSPEC}{Specimen Material Type}
\item{PCLLOQ}{Lower Limit of Quantitation}
\item{VISIT}{Visit Name}
\item{VISITNUM}{Visit Number}
\item{PCDTC}{Date/Time of Specimen Collection}
\item{PCDY}{Actual Study Day of Specimen Collection}
\item{PCTPT}{Planned Time Point Name}
\item{PCTPTNUM}{Planned Time Point Number}
}
}
\source{
\href{https://github.com/pharmaverse/pharmaversesdtm/blob/main/data/pc.rda}{Access the source of the Pharmacokinetic Concentrations dataset.}
}
\usage{
pc
}
\description{
A SDTM PC dataset simulated by Antonio Rodriguez Contesti
}
\details{
Pharmacokinetic Concentrations

A SDTM PC dataset simulated by Antonio Rodriguez Contesti

Contains a set of 1 unique Test Short Name and Test Name: \tabular{ll}{
\strong{PCTESTCD} \tab \strong{PCTEST} \cr
XAN \tab XANOMELINE
}
}
\author{
Antonio Rodriguez Contesti
}
\keyword{dataset}
