% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_fun.R
\name{pcr_standard}
\alias{pcr_standard}
\title{Calculate the standard curve}
\usage{
pcr_standard(df, amount, plot = FALSE)
}
\arguments{
\item{df}{A data.frame of \eqn{C_T} values with genes in the columns and
samples in rows rows. Each sample are replicates of a known input/dilution
given by amount}

\item{amount}{A numeric vector of the input amounts or dilutions. The length
of this vector should equal the row number of df}

\item{plot}{A logical (default FALSE) to indicate whether to return a
data.frame or a plot}
}
\value{
When plot is FALSE returns a data.frame of 4 columns describing the
line between the \eqn{C_T} of each gene and the log of amount
\itemize{
  \item gene The column names of df
  \item intercept The intercept of the line
  \item slope The slope of the line
  \item r_squared The squared correlation
}

When plot is TRUE returns a graph instead shows the average and
standard deviation of of the \eqn{C_T} at different input amounts.
}
\description{
Uses the \eqn{C_T} values from a serial dilution experiment to calculate the
a curve for each gene and the log of the input amount
}
\details{
Fortunately, regardless of the method used in the analysis of qPCR
data, The quality assessment are done in a similar way. It requires an
experiment similar to that of calculating the standard curve. Serial
dilutions of the genes of interest and controls are used as input to
the reaction and different calculations are made.
Curves are required for each gene using the $C_T$ value and the log of the
input amount. In this case, a separate slope and intercept are required for
 the calculation of the relative expression when applying the standard curve
 model.
}
\examples{
# locate and read file
fl <- system.file('extdata', 'ct3.csv', package = 'pcr')
ct3 <- read.csv(fl)

# make amount/dilution variable
amount <- rep(c(1, .5, .2, .1, .05, .02, .01), each = 3)

# calculate the standard curve
pcr_standard(ct3,
             amount = amount)

# plot the standard curve
pcr_standard(ct3,
             amount = amount,
             plot = TRUE)

}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. “Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method.” Methods 25 (4). ELSEVIER.
doi:10.1006/meth.2001.1262.
}
