% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_which.R
\name{osrm_which}
\alias{osrm_which}
\title{Locate the OSRM Installation Used by \code{osrm.backend}}
\usage{
osrm_which(quiet = FALSE)
}
\arguments{
\item{quiet}{Logical; if \code{FALSE} (default), prints information about the located installation. If \code{TRUE}, suppresses printed output and only returns the information as a list.}
}
\value{
A list with components \code{executable} (full path to
\code{osrm-routed}), \code{directory} (its parent folder), \code{osrm_version} (character
vector of non-empty lines emitted by \code{osrm-routed --version}), and the raw
\code{processx::run} result in \code{logs}.
}
\description{
Resolves the \code{osrm-routed} executable available on the current \code{PATH}
(or the override provided via \code{options(osrm.routed.exec)}). Runs
\code{osrm-routed --version} to verify availability, then prints the directory
containing the executable together with the backend version reported by
\code{osrm-routed} so you know what will be used in the current session.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # check which OSRM installation will be used
  osrm_which()

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
}
}
}
